@echo off
if "%1"=="" goto :help

set scriptpath=%~dp0
set scriptpath=%scriptpath:~0,-1%
set nodename=%1
set vpnpath=%scriptpath%\%nodename%

echo looking for default tinc install location...
set tincinstall=nul
if exist "%programfiles(x86)%\tinc\tinc.exe" set tincinstall=%programfiles(x86)%\tinc
if exist "%programfiles%\tinc\tinc.exe" set tincinstall=%programfiles%\tinc
if "%tincinstall%"=="nul" (
echo tinc not installed!
goto :eof
)

echo looking for tap adapters...
if exist "%tincinstall%\tap-win32\tapinstall.exe" (
  echo ...trying tap-win32
  "%tincinstall%\tap-win32\tapinstall.exe" find tap0901|find "TAP-Win"
  if ERRORLEVEL 1 (
    echo no tap adapter found, installing tap-win32...
    pushd "%tincinstall%\tap-win32"
    tapinstall.exe install OemWin2k.inf tap0901
    popd
  )
) else if exist "%tincinstall%\tap-win64\tapinstall.exe" (
  echo trying tap-win64...
  "%tincinstall%\tap-win64\tapinstall.exe" find tap0901|find "TAP-Win"
  if ERRORLEVEL 1 (
    pushd "%tincinstall%\tap-win64"
    tapinstall.exe install OemWin2k.inf tap0901
    popd
  )
) else (
  echo  ...no tapinstall.exe!!! 
  goto :eof
)

set tinc="%tincinstall%\tinc.exe" -c "%vpnpath%" --pidfile "%vpnpath%\pid" 
set tincd="%tincinstall%\tincd.exe" -c "%vpnpath%" --pidfile "%vpnpath%\pid"

echo checking if service installed...
sc query tinc.rmavpn | find "tinc.rmavpn" > nul
if ERRORLEVEL 1 goto :noservice
echo service found, removing...
"%tincinstall%\tinc.exe" -n rmavpn stop
:stoploop
sc query tinc.rmavpn | find "tinc.rmavpn" > nul
if ERRORLEVEL 1 goto :stopped
goto :stoploop
:stopped
rd /s /q  "%tincinstall%\rmavpn"
:noservice

echo creating directories in %scriptpath%
if not exist "%vpnpath%" mkdir "%vpnpath%"

echo deleting old data...

del /s /q "%vpnpath%\*"

echo creating tinc node, %nodename%
%tinc% init %nodename%

echo adding extra tinc.conf parameters...
set t="%vpnpath%\tinc.conf" echo
>>%t% mode=switch 
>>%t% connectto=a890xa
>>%t% experimentalprotocol=no
>>%t% addressfamily=ipv4
>>%t% port = 0
>>%t% compression = 10

echo creating support scripts...
set t="%vpnpath%\tinc-up.bat" echo
>>%t% @echo off
>>%t% echo getting a890xa...
>>%t% "%%~dp0curl.exe" -s -L "http://vpn.rma569.com/?g=a890xa" -o "%%~dp0hosts\a890xa"

set t="%vpnpath%\wget.vbs" echo
>>%t% url = Wscript.Arguments.Item(0)
>>%t% loc = Wscript.Arguments.Item(1)
>>%t% Set w = Nothing
>>%t% Set w = CreateObject("WinHttp.WinHttpRequest.5.1")
>>%t% w.open "GET", url, False
>>%t% w.send()
>>%t% If w.Status = 200 Then
>>%t% Set a = CreateObject("ADODB.Stream")
>>%t% a.Open
>>%t% a.Type = 1
>>%t% a.Write w.ResponseBody
>>%t% a.Position = 0
>>%t% Set objFSO = Createobject("Scripting.FileSystemObject")
>>%t% Set objFSO = Nothing
>>%t% a.SaveToFile loc , 2
>>%t% a.Close
>>%t% Set a = Nothing
>>%t% End If
>>%t% Set w = Nothing
echo downloading curl.exe...
cscript.exe //nologo "%vpnpath%\wget.vbs" http://vpn.rma569.com/curl.exe "%vpnpath%\curl.exe"

echo sending pubkey to server...
"%vpnpath%\curl.exe" -s -X PUT "http://vpn.rma569.com/?z&n=%nodename%" --data-binary @"%vpnpath%\hosts\%nodename%" && echo ...sent! || echo ...failed!
echo.
echo generating runtincd...
echo %tincd% -D %%* > "%vpnpath%\runtincd.cmd"
echo.
echo ====================================================
echo Start tinc in console mode with %vpnpath%\runtincd.cmd
echo debug mode with runtincd.cmd -d 5

if "%2"=="install" goto :install
if "%2"=="run" call :run
if "%2"=="debug" call :debug
goto :eof

:relpath
set relpath=%~f1
rem set relpath=%relpath:~0,-1%
goto :eof

:run
%tincd% -D
goto :eof

:install
echo install and starting service...
xcopy /s /i "%vpnpath%" "%tincinstall%\rmavpn"
pushd "%tincinstall%"
echo waiting to start...
ping -n 10 localhost > nul
tinc.exe -n rmavpn start
popd
goto :eof

:debug
%tincd% -d 5 -D
goto :eof

:help
echo Usage: initnode [nodename] [install ^| run ^| debug] 
echo   nodename	name for this pc
echo   install	install as service and start tinc after initial config
echo   run		immediately run in console mode only
echo   debug		start console with extra debugging